%% Noised data simulator for a first order identification
% Justin Cano, 2017
% Please use your data for identification and not this dummy example script
% thank you!
clear all
% We gave this constants for the electrical motor (example)
K = 10;
tau = 0.2;

% Step amplitude (amplitude echelon)
amplitude = 5; % 5v is our step amplitude

% Discretization of the timestamp (in seconds)
n_sample = 50;
initial_time = 0;
final_time = 3; 
t = linspace(initial_time,final_time,n_sample);

% Simulation of the response
y = K*amplitude*(1-exp(-t/tau));
% Random noise, PDF N(0,1.5^2)
noise = normrnd(0,1.5,1,length(t));
% Measure simulation
y_mesured = y+noise;
t_mesured = t;
% Save the simulated mesure to workspace
save('mesures.mat','y_mesured','t_mesured')
