%% Least Square estimator for first order
% Justin Cano, 2017
% Please use your own data for identification and not this dummy example script
% thank you!
clear all
close all
% Global variables
global t y_mes

%  Known amplitude of our step (TODO : modify this dummy value)
amplitude = 5;
% Load your own data (TODO : Be aware of the names)
load('mesures.mat')
% Extracted data
t = t_mesured;
y_mes = y_mesured/amplitude; % Do not forget to normalize by the amplitude of the step this vector!



% Non-linear least square optimization with external function
% Xo is choosen randomly
X_id = lsqnonlin(@error_model,[1 1]'); 

K = X_id(1) 
tau = X_id(2)

% Plot confrontation 

% First order identified model simulation
y_simulated = K.*(1-exp(-t./tau));
figure(1)
plot(t,y_simulated); % Simulation
hold on
plot(t,y_mes,'o'); % Measures 
title('Identification vs raw data')
legend('Simulated','Measured')

%% Confidence
square_err = (y_simulated-y_mes).^2;
normalized_mean_square_error = mean(square_err)/(mean(y_simulated)*mean(y_mes))


