% Repulsor masked matrix : precalculum

mu = 0.1;
rho = 31;
cm_per_pixel = 10;
mask_size_required = floor(rho/cm_per_pixel)*2 + 1;
center =  floor(rho/cm_per_pixel)+1;

% Prealocation of the matrices
matrix_x = zeros(mask_size_required,mask_size_required);
matrix_y = zeros(mask_size_required,mask_size_required);

% Main loop
for x=1:mask_size_required
    for y=1:mask_size_required
        
        % At the center, the potential is infinite, our convention is to
        % mark the gradient as well as infinite, this means that we can not
        % choose to go at this point.
        if x==center && y==center
            matrix_x(x,y) = inf;
            matrix_y(x,y) = inf;
            % If we are in the influency zone of the potential, we can
            % compute a non-null value
        else
            d = sqrt((x-center)^2+(y-center)^2);
            if d<rho
                d3 = d^3;
                coeff = -mu*(1/d-1/rho)/d3;
                matrix_x(x,y) = coeff*(x-center);
                matrix_y(x,y) = coeff*(y-center);
            end
        end
    end
end

matrix_x
matrix_y

% We can remark another important thing... if we compare a matrix to the
% transpose of the other we have the same thing...
matrix_x - matrix_y'
