function [ potential_map, gradx,grady ] = repulsion(map, H, L)
% Potential function
K = 100;
rho=12;

potential_map = zeros(H,L);
gradx = zeros(H,L);
grady = zeros(H,L);

% For each obstruated pixel
for io=1:H
    for jo=1:L
        if map(io,jo)==1
            % Compute potential contribution in the map of obstacle pixel
            for i=1:H
                for j=1:L
                    if j==jo && i==io
                        % The value of the potential and its gradient on
                        % the obstacle point is assumed to be infty
                        % (forbiden value).
                        potential_map(i,j)=inf;
                        gradx(i,j)=nan;
                        grady(i,j)=nan;
                    else
                        d = sqrt((i-io)^2+(j-jo)^2);
                        % If considerated point is within the influence
                        % zone
                        if d<rho
                            potential_map(i,j)= potential_map(i,j)+0.5*K*(1/d-1/rho)^2;
                            coeff = -K*(1/d - 1/rho)/(d^3);
                            gradx(i,j)=gradx(i,j)+coeff*(i-io);
                            grady(i,j)=grady(i,j)+coeff*(j-jo);
                        end
                    end
                end
            end
        end
    end
end

end

