%% Planification
clear all
% Map allocation
L=35;
H=25;
carte = zeros(H,L);

% Initial and objective point
x0 = 8; y0 = 5;
xf = 16; yf = 30;

% Obstacle marking (DO NOT FORGET TO DILATE with respect to the robot
% radius this map, we assume that is alredy done, you have the matlab function imdilate
% if you want to test but is not dificult to code, OR function with respect
% to a radial shape)
for i=1:H
    for j=1:L
        % Boundaries are obstacles
        carte(1,j)=1;
        carte(H,j)=1;
        carte(i,L)=1;
        carte(i,1)=1;
        % Elliptic obstacles (example)
         if (i-8)^2+2*(j-11)^2<3^2 || 2*(i-16)^2+(j-20)^2<3^2
             carte(i,j)=1;
         end
    end
end
%carte = logical(carte);

%% Potential and gradient calculum
[rep_pot,gradrepx,gradrepy] = repulsion(carte,H,L);
[atr_pot,gradatrx,gradatry] = attraction(H,L,xf,yf);
% Sum of potentials and sum of gradients
pot = atr_pot + rep_pot;
gradx = gradatrx + gradrepx;
grady = gradatry + gradrepy;

%% Gradient Algorithm
radius = 1;
d = 666;
k = 1;
path(1,:)=[x0 y0];
% Main loop
% The first stop test is for safety only (local minima for example) the
% second one is the stop test used while the process normaly exits.
while k<100 && d>radius
    % Gradient algo
    % Gradient at the point k of the path
    grad_point_k = [gradx(path(k,1),path(k,2)),grady(path(k,1),path(k,2))];
    % Normalization coeff : we want unitary gradient
    grad_norm_k = 1.41*grad_point_k/norm(grad_point_k);
    % Gradient propagation
    path(k+1,:) = path(k,:)-floor(grad_norm_k);
    % Distance to the final goal
    d = norm(path(k+1,:)-[xf,yf]);
    k = k+1;
end

% Trajectory regularisation (2 by two mean) if the trajectory points are
% odd the last one is conserved (arbitrary)
length_path=length(path(:,1));
for i=1:floor(length_path/2)
    regul_path(i,:)=floor(0.5*(path(2*i-1,:)+path(2*i,:)));
end
if mod(length_path,2)==1
    regul_path(i+1,:)=path(length_path,:);
end

%
figure()
imagesc(1:L,1:H,carte)
hold on
scatter(y0,x0,'r');
scatter(yf,xf,'g');

title('Carte simple, obstacles seuls')
legend('Position initiale','Position finale')

%% Show the potential
figure()
imagesc(1:L,1:H,pot)
hold on
plot(path(:,2),path(:,1),'d','Color','g');
scatter(regul_path(:,2),regul_path(:,1),'O','filled')
scatter(y0,x0,'O','filled')
scatter(yf,xf,'O','filled')
plot(regul_path(:,2),regul_path(:,1),'--','Color','y')
legend('Descente du gradient de potentiel','Trajectoire lissee','Position initiale','Position finale')
title('Carte de potentiel')

% %% Show the potential gradient (time costing...)
% 
% orientation = atan2(gradx,grady);
% magnitude = sqrt(gradx.^2+grady.^2);
% 
% figure()
% imagesc(1:L,1:H,pot)
% hold on
% scatter(y0,x0,'r');
% scatter(yf,xf,'g');
% 
% a = -0.05;
% for i=1:H
%     for j=1:L
%         quiver(j,i,a*(magnitude(i,j)+0.2)*cos(orientation(i,j)),a*(magnitude(i,j)+0.2)*sin(orientation(i,j)));
%     end
% end
% 
% legend('Position initiale','Position finale')
% title('Visualision de l oppose du gradient de potentiel')


%% Attractive and repulsive potential
figure()
subplot(1,2,1)
imagesc(1:L,1:H,rep_pot)
title('Potentiel repulsif')
subplot(1,2,2)
imagesc(1:L,1:H,atr_pot)
title('Potentiel attractif')