%% Trapezoid generation function
function y = trapezoid(u)
t = u;
% We assume that the trapezoid is symetrical
omega_cruize = 5;
rise_time = 2.5;
cruize_time = 4;
% First step linear rising
if t<rise_time
    y = omega_cruize*(t/rise_time);
    % Cruize step
else if t<rise_time+cruize_time
        y = omega_cruize;
        % Linear stopping
    else if t<rise_time*2 + cruize_time
            y = omega_cruize*(1-((t-rise_time-cruize_time)/rise_time));
        else
            y = 0;
        end
    end
end
end