clear all
close all

% Parametres du moteur
K = 40;
tau = 0.3;

%Coefficients du polynome des poles choisis D = (s-p1)(s-p2)
a1 = 12; 
a0 = 72;

Kp = (a1*tau - 1)/K;
Ki = (a0*tau)/K;

%Création des fonctions de transfert en continu
s = tf('s');
F = K/(s*tau + 1)
C = (s*Kp + Ki)/s
H = (C*F)/(1+C*F);
Rejet = -0.05*F/(1+C*F);
%Simulation temporelle en continu du système en BF (poursuite et rejet)
step(H, Rejet); %On poursuit un echelon unitaire et on rejette -5% de sa valeur

%discretisation du controleur
Ts = 0.05;
C_e = c2d(C,Ts)
F_e = c2d(F,Ts);

H_e = (C_e*F_e)/(1+C_e*F_e);
step(H_e);
